/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.screen.animator.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.StringTextComponent;

public class IconButton
extends Button {
    public static final Settings SETTINGS = new Settings();
    private final ResourceLocation source = Settings.access$000(SETTINGS);
    private final float xTex1;
    private final float yTex1;
    private final float xTex2;
    private final float yTex2;

    public IconButton(int x, int y, int width, int height, int textureIndex, Button.IPressable pressable, Button.ITooltip tooltip) {
        super(x, y, width, height, StringTextComponent.field_240750_d_, pressable, tooltip);
        int max = SETTINGS.cells;
        int tx = textureIndex % max;
        int ty = textureIndex / max;
        int texSize = SETTINGS.texSize;
        int size = max * SETTINGS.texSize;
        int xTex = tx * texSize;
        int yTex = ty * texSize;
        this.xTex1 = (float)xTex / (float)size;
        this.yTex1 = (float)yTex / (float)size;
        this.xTex2 = (float)(xTex + texSize) / (float)size;
        this.yTex2 = (float)(yTex + texSize) / (float)size;
    }

    public void func_230431_b_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        if (this.func_230449_g_() && this.field_230693_o_) {
            AbstractGui.func_238467_a_((MatrixStack)stack, (int)(this.field_230690_l_ - 1), (int)(this.field_230691_m_ - 1), (int)(this.field_230690_l_ + this.field_230688_j_ + 1), (int)(this.field_230691_m_ + this.field_230689_k_ + 1), (int)0x67FFFFFF);
            this.func_230443_a_(stack, mouseX, mouseY);
        }
        this.fillUV(stack.func_227866_c_().func_227870_a_(), this.field_230690_l_, this.field_230691_m_, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + this.field_230689_k_, this.field_230693_o_ ? -1 : 0x67999999);
    }

    private void fillUV(Matrix4f pose, int x1, int y1, int x2, int y2, int colorMask) {
        int alpha = colorMask >> 24 & 0xFF;
        int red = colorMask >> 16 & 0xFF;
        int green = colorMask >> 8 & 0xFF;
        int blue = colorMask & 0xFF;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.source);
        builder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        builder.func_227888_a_(pose, (float)x1, (float)y1, 0.0f).func_225586_a_(red, green, blue, alpha).func_225583_a_(this.xTex1, this.yTex1).func_181675_d();
        builder.func_227888_a_(pose, (float)x1, (float)y2, 0.0f).func_225586_a_(red, green, blue, alpha).func_225583_a_(this.xTex1, this.yTex2).func_181675_d();
        builder.func_227888_a_(pose, (float)x2, (float)y2, 0.0f).func_225586_a_(red, green, blue, alpha).func_225583_a_(this.xTex2, this.yTex2).func_181675_d();
        builder.func_227888_a_(pose, (float)x2, (float)y1, 0.0f).func_225586_a_(red, green, blue, alpha).func_225583_a_(this.xTex2, this.yTex1).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableBlend();
    }

    public static class Settings {
        private ResourceLocation src;
        private int cells;
        private int texSize;

        public void set(ResourceLocation src) {
            this.set(src, this.cells, this.texSize);
        }

        public void set(ResourceLocation src, int cells) {
            this.set(src, cells, this.texSize);
        }

        public void set(ResourceLocation src, int cells, int texSize) {
            this.src = src;
            this.cells = cells;
            this.texSize = texSize;
        }

        static /* synthetic */ ResourceLocation access$000(Settings x0) {
            return x0.src;
        }
    }
}

